
#include "p33Fxxxx.h"
#include "audio.h"
#include "sine.h"

// Device configuration registers
_FGS(GWRP_OFF & GCP_OFF); // we don't want to write protect the flash
_FOSCSEL(FNOSC_FRC); // start up initially without the PLL but instead using the internal fast RC oscillator
_FOSC(FCKSM_CSECMD & OSCIOFNC_OFF & POSCMD_HS);
_FWDT(FWDTEN_OFF); // not using the watchdog timer
#ifdef __DEBUG
_FICD( ICS_PGD3&JTAGEN_OFF );
#else
_FICD( ICS_NONE&JTAGEN_OFF );
#endif

unsigned short ADCBufA[2] __attribute__((space(dma)));
unsigned short ADCBufB[2] __attribute__((space(dma)));

volatile unsigned int CurrentADCDMABuffer = 0;
void __attribute__((__interrupt__,no_auto_psv)) _DMA0Interrupt(void) {
	if( CurrentADCDMABuffer == 0 ) {
	} else {
	}
	CurrentADCDMABuffer ^= 1;
	IFS0bits.DMA0IF = 0; //Clear the DMA0 Interrupt Flag
}

int main(void) {
	unsigned short sine_pos = 0;

	TRISAbits.TRISA0 = 0;
	LATAbits.LATA0 = 0;

	TRISBbits.TRISB0 = 0;
	LATBbits.LATB0 = 1;

	TRISBbits.TRISB1 = 0;
	LATBbits.LATB1 = 0;

	TRISBbits.TRISB4 = 0;
	LATBbits.LATB4 = 0;

	TRISAbits.TRISA4 = 0;
	LATAbits.LATA4 = 1;

	TRISBbits.TRISB5 = 0;
	LATBbits.LATB5 = 0;
	TRISBbits.TRISB6 = 0;
	LATBbits.LATB6 = 1;
	TRISBbits.TRISB7 = 0;
	LATBbits.LATB7 = 0;
	TRISBbits.TRISB8 = 0;
	LATBbits.LATB8 = 1;
	TRISBbits.TRISB9 = 0;
	LATBbits.LATB9 = 0;

	audio_set_sample_rate(44100);
    PR2 = 7-1;
    PR3 = 7*32-1;
	T2CONbits.TON = 1;
	T3CONbits.TON = 1;
	RPOR3bits.RP7R = 18; // RP7/RB7 (pin 16) = OC1
	OC1CONbits.OCM = 6; // PWM
	OC1RS = 3;
    TRISBbits.TRISB7 = 0;

	AD1CON1bits.AD12B = 1;
	AD1CON3bits.ADCS = 15; // (max) 40MHz / 16 / 14 = 179kHz
	AD1CON1bits.ASAM = 1;
	AD1CON1bits.SSRC = 7;//2;
	AD1CON1bits.FORM = 0;
	AD1CON1bits.ADDMABM = 1;
	AD1CON2bits.CSCNA = 1; // scan inputs
	AD1CSSLbits.CSS4 = 1;
	AD1CSSLbits.CSS5 = 1;
	AD1CHS0bits.CH0SA = 4;

	IFS0bits.AD1IF = 0;
	IEC0bits.AD1IE = 0;

	DMA0CONbits.AMODE = 0;//2;	// Configure DMA for Peripheral indirect mode
	DMA0CONbits.MODE = 2;	// Configure DMA for Continuous Ping-Pong mode
	DMA0PAD = 0x0300;		// Point DMA to ADC1BUF0
	DMA0CNT = 1;			// 2 words per DMA session
	DMA0REQ = 13;			// Select ADC1 as DMA Request source
	DMA0STA = __builtin_dmaoffset(&ADCBufA);
	DMA0STB = __builtin_dmaoffset(&ADCBufB);
	IFS0bits.DMA0IF = 0;	//Clear the DMA interrupt flag bit
	IEC0bits.DMA0IE = 1;	//Set the DMA interrupt enable bit
	DMA0CONbits.CHEN = 1;

	AD1CON1bits.ADON = 1;
	AD1CON1bits.SAMP = 1;

	RPOR2bits.RP4R = 13; // DCI CSDO
	RPOR4bits.RP9R = 15; // DCI COFS
	RPINR24bits.CSCKR = 10; // DCI CSCK
	DCICON1bits.COFSM = 1; // I2S
	DCICON1bits.CSCKE = 1; // required for I2S
	DCICON1bits.CSCKD = 1; // DCI clock is an input
	DCICON2bits.WS = 15;
	TSCON = 1;
	IFS3bits.DCIIF = 0;
	TXBUF0 = 0x5555;
	DCICON1bits.DCIEN = 1;

	LATBbits.LATB1 = 1;

	while(1) {
		if( IFS3bits.DCIIF ) {
			IFS3bits.DCIIF = 0;
//			TXBUF0 = sine_44_1_10cycles[sine_pos>>1];
			TXBUF0 = CurrentADCDMABuffer ? ADCBufA[sine_pos&1] : ADCBufB[sine_pos&1];
			if( ++sine_pos == 441*2 )
				sine_pos = 0;
		}
	}
}
